/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */       
/*
 * Test Routines for SDIO cards on DM388 board.
 * 
 */

#include "dm388_types.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "sdmmc.h"

#define SDIO_VENDOR_ID_TI			0x0097
#define SDIO_DEVICE_ID_TI_WL1271	0x4076
#define TIWL1271_CHIPID				(SDIO_DEVICE_ID_TI_WL1271 << 16 | SDIO_VENDOR_ID_TI)

#define WR_MEM_32(addr, data)    *(unsigned int*)(addr) =(unsigned int)(data)
#define RD_MEM_32(addr) 		 *(unsigned int*)(addr)

#define CTRL_MODULE_BASE_ADDR     0x48140000
#define    PINCNTL8    (    CTRL_MODULE_BASE_ADDR +    0x081C    )
#define    PINCNTL9    (    CTRL_MODULE_BASE_ADDR +    0x0820    )
#define    PINCNTL10    (    CTRL_MODULE_BASE_ADDR +    0x0824    )
#define    PINCNTL11    (    CTRL_MODULE_BASE_ADDR +    0x0828    )
#define    PINCNTL12    (    CTRL_MODULE_BASE_ADDR +    0x082C    )
#define    PINCNTL13    (    CTRL_MODULE_BASE_ADDR +    0x0830    )
#define    PINCNTL106    (    CTRL_MODULE_BASE_ADDR +    0x09A4    )

void wlan_pin_mux()
{
	/* GP3[3] configuration  */
	WR_MEM_32(PINCNTL8, 0x00060001);

	/* GP0[9] configuration  */
	WR_MEM_32(PINCNTL9,  0x000E0001);

	/* GP1[24] configuration  */
	WR_MEM_32(PINCNTL10, 0x000E0001);

	/* GP1[25] configuration  */
	WR_MEM_32(PINCNTL11, 0x000E0001);

	/* GP1[30] configuration  */
	WR_MEM_32(PINCNTL12, 0x000E0001);

	WR_MEM_32(PINCNTL13, 0x000E0001);

	WR_MEM_32(PINCNTL106, 0x00040080);

}


INT32 wlan_test(void *testargs)
{
	INT32  cardtype;
	INT32  is_highcap_card = 0;
	INT32  retval = SUCCESS;
	UINT32 chipid;

	//DM388_WLANInit();
#ifdef PRINTF
    platform_write ("SDIO Tests:\n");
	platform_write ("*) Test communicates with an SDIO WLAN Chip and displays its ChipID\n");
	platform_write ("*) Ensure that the Boot Switches are selected as specified in the README\n");
#endif
    platform_write("\n*************************\n\r");
    platform_write(  "         WLAN Test       \n\r");
    platform_write(  "*************************\n\r");
	//wlan_pin_mux();
	chipid = 0x0;
	mmcinit((hsmmc_t *) HSMMC_BASE0);

	platform_write("\nRunning WLAN Chip Detect Test\n");
	cardtype = detect_card((hsmmc_t *) HSMMC_BASE0, &is_highcap_card);
	
	if (cardtype == SDIO_CARD)
	{
		platform_write ("SDIO Card Detected\n");
		retval = get_sdio_chipid((hsmmc_t *) HSMMC_BASE0, &chipid);
		if (retval == SUCCESS) {
			if (chipid == TIWL1271_CHIPID)
			{
				platform_write ("WL1837 WLAN Chip Detected with an Manfacturer ID of 0x%08x\n", chipid);
				platform_write("WLAN Chip Detect Test Passed\n");
			}
			else
				platform_write ("An SDIO Device detected with an Manfacturer ID of 0x%08x\n", chipid);
		} else {
			platform_write ("Unable to read the chip id of the SDIO Card\n");
		}
	}
	else
	{
		platform_write ("Unable to detect an SDIO card\n");
		platform_write("WLAN Chip Detect Test Failed\n");
		retval = FAILURE; 
	}

	if (retval == SUCCESS)
	{
		platform_write ("\nWLAN Test Passed!\n");
		platform_write("\nWLAN Test Completed!!\n");
		platform_write("-----------x----------");
		return SUCCESS;
	}
	else
	{
		platform_write ("\nWLAN Test Failed!\n");
		platform_write("-----------x----------");
		return FAILURE;
	}
}
